# Architecture and Code Explanation

This document provides a technical overview of the system architecture and key code components.

## System Architecture

The system is composed of three decoupled microservices that interact via HTTP APIs.

```mermaid
graph TD
    User[User / Astronaut] -->|Views| Dashboard
    User -->|Speaks/Inputs| ESP32[(ESP32 / Simulation)]
    
    subgraph "Local Network / Host Machine"
        ESP32 -->|POST Sensor Data| Dashboard
        ESP32 -->|POST Context + Input| LLM_Server
        
        Dashboard[Dashboard Server (Flask)]
        LLM_Server[LLM Interaction Server (Flask)]
        Sensor_API[Sensor Simulation API (Flask)]
        
        Dashboard -->|Polls| Sensor_API
        LLM_Server -->|Reads| Conversation_History[conversation_history.json]
        LLM_Server -->|Writes| Conversation_History
    end
    
    LLM_Server -->|API Call| OpenAI[OpenAI API]
```

## Component Breakdown

### 1. Simulated Time and Sensor APIs
- **Role**: Acts as a mock for physical hardware sensors. It generates realistic, slightly random variations of temperature and humidity.
- **Key File**: `api_server.py`
    - `/time`: Returns current Earth and calculated Mars time (MTC).
    - `/dht22`: Returns simulated temperature and humidity.

### 2. LLM Interaction APIs
- **Role**: The "brain" of the companion bot. It processes user input along with environmental context (temp, humid, time) to generate accurate responses.
- **Key File**: `server.py`
    - **Contextual Awareness**: Injects sensor data into the system prompt.
    - **Prompt Engineering**: The `system_prompt.txt` defines the bot's persona (concise, helpful, sci-fi style).
    - **Memory**: Stores the last `N` turns of conversation in `conversation_history.json` to maintain context.

### 3. Dashboard
- **Role**: The Mission Control interface for visualization.
- **Key File**: `app.py` & `templates/index.html`
    - **App**: Serves the web page and handles the webhook for incoming data.
    - **Template**: Uses HTML/JS to poll for updates and dynamically render the UI.
    - **Audio**: Integrates Text-to-Speech (TTS) logic to vocalize new messages.

## Data Flow
1. **Input**: User speaks to the ESP32 (or inputs text).
2. **Context**: ESP32 gathers sensor data.
3. **Processing**: Request is sent to `LLM_Interaction_APIs`.
4. **Intelligence**: Server calls OpenAI with (System Prompt + History + Context + User Input).
5. **Response**: OpenAI returns a text response.
6. **Storage**: Interaction is saved to `conversation_history.json`.
7. **Display**: 
    - Dashboard detects change in JSON file or via Webhook.
    - UI updates with new message.
    - Audio system plays the response.
